node-csrf: Light-weight CSRF protection middleware with IP whitelisting
=================================================================================

This package provides easy cross-site request forgery protection, while providing IP whitelisting for external Webhook type scenarios. 

[![Build Status](https://secure.travis-ci.org/Dwolla/node-csrf.png?branch=master)](http://travis-ci.org/Dwolla/node-csrf)

## Version
0.0.3

## Requirements
- [Node](http://github.com/ry/node)

## Installation

Recommended installation is with npm. To add node-csrf to your project, do:

    npm install csrf

## Usage with Express
```javascript
// Init dependencies
var express = require('express')
    , csrf = require('csrf')
    , app = express.createServer()
    ;

// Whitelist the following IPs
var ips = ['127.0.0.1'];

// Create a View helper for 
// easy access to the CSRF token
// within template view files
// (i.e. <input type="hidden" name="_csrf" value="<%= _csrf %>" />)
app.dynamicHelpers({
	_csrf: function(req, res) {
		return req.session._csrf;
	}
});

// Create the server
app.use(csrf(ips));
app.listen(3000);
```

## Changelog

0.0.3

* Add 'crypto' as a dependency

0.0.2

* fixing arguments re-declarations
* leverage _.defaults
* normalize header access to work without express/connect
* adding license info / normalizing package.json (via npm init)
* normalize mixed soft & hard tabs
* bumping to version 0.0.2

0.0.1

* first revision

## Credits

* Michael Schonfeld &lt;michael@dwolla.com&gt;
* Sam Breed &lt;sam@quickleft.com&gt;

## License 

(The MIT License)

Copyright (c) 2012 Dwolla &lt;michael@dwolla.com&gt;

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
'Software'), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
